/* 
 * main.c 
 *
 * Створює дочірній процес і передає повідомлення від дочірнього процесу 
 * батьківському. Отримане від дочірнього процесу повідомлення 
 * батьківський процес виводить у стандартний потік виведення результатів.
 * Ілюструє порядок застосування функцій fork(), wait().
 *
 */

#include "myheader.h"


FILE *stream;

int main()
{
        pid_t child_pid;
        char filename[] = "/tmp/myprogram.XXXXXX";
        int fd;

        printf("Parent: The main program's PID is %u\n",
                                        (unsigned int) getpid());

        /* Створює тимчасовий файл. */
        fd = mkstemp(filename);
        if (fd < 0) {
                fprintf(stderr, "Parent: Can't create temporary file:"
                                                " %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }
        stream = fdopen(fd, "r+");
        if (stream == NULL) {
                fprintf(stderr, "Parent: Can't create stream for"
                " temporary file %s: %s\n", filename, strerror(errno));
                exit(EXIT_FAILURE);
        }
        if (unlink(filename) < 0)
                fprintf(stderr, "Parent: Error unlinking temporary file"
                                " %s: %s\n", filename, strerror(errno));

        /* Створює дочірній процес. */
        child_pid = fork();
        if (child_pid != 0) {
                /* Це батьківський процес */
                if (child_pid == -1) {
                        /* Помилка при створенні дочірнього процесу. */
                        fprintf(stderr, "Parent: Error creating a child:"
                                        " %s\n", strerror(errno));
                        exit(EXIT_FAILURE);
                }
                exit(parent(child_pid));
        } else {
                /* Це дочірній процес */
                exit(child());
        }	
}
